/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.allocator;

/**
 * Implementation of the {@link Allocator} interface which allocates fresh
 * data array at each request and has no memory usage control.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */

public class DirectAllocator implements Allocator {
    /**
     * Creates a fresh buffer containing zeroed-out array of the specified size.
     * @param size the requested buffer size
     * @param clear ignored
     * @param timeout ignored
     * @return newly allocated buffer
     */
    public Buffer allocate(int size, boolean clear, long timeout) {
        byte[] data = new byte[size];
        return new Buffer(data, size) {
            public void reclaim() {}
        };
    }
}
